<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class ThreeDigit extends Model 
{

    protected $table = 'three_digits';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('digits', 'primary_amount', 'secondary_amount', 'user_id');

    public function threeDigitsUser()
    {
        return $this->hasOne('User', 'user_id');
    }

}